<?php
namespace controller;

class Users extends \Pawn\Controller
{
	public function _construct()
	{
		\lib\Lang::load('users');
	}
	
	# Leaderboard
	public function leaderboard($filter='all', $page=1)
	{
		// Filter
		$filtering = array
		(
			'all'	=>	0,
			'month'	=>	31556925,
			'week'	=>	2629744,
			'day'	=>	86400
		);
		
		foreach($filtering as $key=>$length)
		{
			if($length)
			{
				$rows = \lib\db::query('SELECT user_id FROM '.\model\Points::table_name().' WHERE ts_create>? GROUP BY user_id ORDER BY SUM(points) DESC', time() - $length)->fetchAll();
				
				if(!$rows)
				{
					unset($filtering[$key]);
				} else
				{
					$filtering[$key] = $rows;
				}
			}
		}
		
		if(!isset($filtering[$filter]))
		{
			$filter = 'all';
		}
		
		if($filter == 'all')
		{
			$total = \model\User::num_rows();
		} else
		{
			$users = array();
			
			foreach($filtering[$filter] as $rank=>$row)
			{
				$users[] = \model\User::get('WHERE id=?', $row['user_id'])->fetch();
			}
			
			$total = count($users);
		}
		
		// Page
		$pageSize = 14;
		
		if(\Pawn::setting('ad_200x90'))
		{
			$pageSize--;
		}
		
		$pages = ceil($total/$pageSize);
		
		if($page < 1)
		{
			$page = 1;
		} elseif($page > $pages)
		{
			$page = $pages;
		}
		
		if($filter == 'all')
		{
			$users = \model\User::get('ORDER BY points DESC LIMIT '.(($page-1)*$pageSize).','.$pageSize)->fetchAll();
		} else
		{
			$users = array_slice($users, ($page-1)*$pageSize, $pageSize);
		}
		
		// Render
		return $this->render('users/leaderboard.html', array
		(
			'filter'	=>	$filter,
			'page'		=>	$page,
			
			'filtering'	=>	$filtering,
			'pages'		=>	$pages,
			'pageSize'	=>	$pageSize,
			
			'users'		=>	$users
		));
	}
	
	# Search
	public function search($input, $page)
	{
		// Input
		$words = explode(' ', urldecode($input));
		
		$query = '';
		
		foreach($words as $i=>$word)
		{
			if(strlen($word) == 1)
			{
				continue;
			}
			
			if($query)
			{
				$query .= ' OR ';
			}
			
			$query .= 'username LIKE '.\lib\db::quote('%'.$word.'%');
		}
		
		if($query)
		{
			$users = \model\User::get('WHERE '.$query)->fetchAll();
		} else
		{
			$users = array();
		}
		
		// Page
		$pageSize = 14;
		
		if(\Pawn::setting('ad_200x90'))
		{
			$pageSize--;
		}
		
		$total = count($users);
		$pages = ceil($total/$pageSize);
		
		if($page < 1)
		{
			$page = 1;
		} elseif($page > $pages)
		{
			$page = $pages;
		}
		
		$users = array_slice($users, ($page-1)*$pageSize, $pageSize);
		
		// Render
		return $this->render('users/search.html', array
		(
			'input'		=>	$input,
			'page'		=>	$page,
			
			'total'		=>	$total,
			'pages'		=>	$pages,
			
			'users'		=>	$users
		));
	}
	
	# Profile
	public function profile($name, $category='favourites', $order='date', $dir='desc', $page=1)
	{
		$user = \model\User::get('WHERE username=?', $name)->fetch();
		
		if(!$user)
		{
			return $this->not_found();
		}
		
		$user->views++;
		
		// Vars
		$vars = array
		(
			'category'		=>	$category,
			'categories'	=>	array('favourites', 'friends'),
			
			'profile'		=>	$user,
			'path'			=>	\Pawn::path('Users', 'profile', array('name'=>$name, 'category'=>$category, 'order'=>'{order}', 'dir'=>'{dir}', 'page'=>'{page}')),
			
			'rated'			=>	($this->user->authenticated() && $rating = \model\Rating::get('WHERE user_id=? AND target="user" AND target_id=?', array($this->user->id, $user->id))->fetch())?$rating->stars:0,
			'friended'		=>	($this->user->authenticated() && \model\Friend::get('WHERE user_id=? AND target_id=?', array($this->user->id, $user->id))->fetch())?true:false,
		);
		
		// Games
		$games = \Pawn::controller('Games', true);
		
		// Statistics
		$vars['points_per_day'] = round($user->points*86400/(time() - $user->ts_create));
		
		$plays = \model\Plays::get('WHERE user_id=?', $user->id)->fetchAll();
		$categories = array();
		$most_played = array();
		
		foreach($plays as $play)
		{
			$genre = $play->game->category_id;
			
			$most_played[$play->game_id] = $play->times;
			
			$categories[$genre] = $play->times + (isset($categories[$genre])?$categories[$genre]:0);
		}
		
		$favourite_genre = $categories?\model\Category::get('WHERE id=?', array_search(max($categories), $categories))->fetch():false;
		
		$vars['most_played'] = $most_played?\model\Game::get('WHERE id=?', array_search(max($most_played), $most_played))->fetch():false;
		$vars['favourite_genre'] = $favourite_genre?array
		(
			'name'	=>	$favourite_genre->__toString(),
			'slug'	=>	array_search($favourite_genre->name, $games->categories)
		):false;
		
		// Friends
		$vars['friends_total'] = \model\Friend::num_rows('WHERE user_id=?', $user->id);
		
		// Comments
		$vars['write_comment'] = new \lib\Form('comment');
		$vars['write_comment']->field('message', 'textarea', array(), \lib\Lang::get('comment_placeholder'));
		
		$vars['comments'] = \model\Comment::get('WHERE target="user" AND target_id=? ORDER BY ts_edit DESC LIMIT 50', $user->id)->fetchAll();
		
		// Page
		if(!in_array($category, $vars['categories']))
		{
			$category = 'favourites';
		}
		
		// Render
		switch($category)
		{
			case 'favourites':
				return $this->render('users/favourites.html', array_merge($vars, $games->favourites($vars['profile'], $order, $dir, $page)));
			break;
			case 'friends':
				return $this->render('users/friends.html', array_merge($vars, $this->friends($user, $order, $dir, $page)));
			break;
		}
	}
	
	# Order
	private $order, $dir;
	
	public function order($a, $b)
	{
		$order = $this->order;
		
		if($a->$order)
		{
			$a = $a->$order;
			$b = $b->$order;
		} else
		{
			$a = $a->$order();
			$b = $b->$order();
		}
		
		if($a == $b)
		{
			return 0;
		}
		
		return (($this->dir == 'desc')?1:-1)*(($a < $b)?1:-1);
	}
	
	# Friends
	private function friends($user, $order, $dir, $page)
	{
		// Users
		$users = array();
		
		// Friends
		$friends = \model\Friend::get('WHERE user_id=?', $user->id)->fetchAll();
		
		foreach($friends as $friend)
		{
			$users[$friend->ts_create] = \model\User::get('WHERE id=?', $friend->target_id)->fetch();
		}
		
		// Direction
		$dir = ($dir == 'asc')?'asc':'desc';
		
		// Ordering
		$ordering = array
		(
			'date'			=>	'id',
			'name'			=>	'username',
			'rank'			=>	'rank',
			'rating'		=>	'rating'
		);
		
		if(!isset($ordering[$order]) || $order == 'date')
		{
			$order = 'date';
			
			if($dir == 'asc')
			{
				ksort($users);
			} else
			{
				krsort($users);
			}
		} else
		{
			$this->dir = $dir;
			$this->order = $ordering[$order];
			
			usort($users, array($this, 'order'));
		}
		
		foreach($ordering as $key=>$value)
		{
			$ordering[$key] = \lib\Lang::get('ordering', $key);
		}
		
		// Page
		$pageSize = 6;
		
		if(\Pawn::setting('ad_200x90'))
		{
			$pageSize--;
		}
		
		$total = count($users);
		
		$from = ($page-1)*$pageSize+1;
		$to = $page*$pageSize;
		
		if($to > $total)
		{
			$to = $total;
		}
		
		$pages = ceil($total/$pageSize);
		
		if($page < 1)
		{
			$page = 1;
		} elseif($page > $pages)
		{
			$page = $pages;
		}
		
		$users = array_slice($users, ($page-1)*$pageSize, $pageSize);
		
		// Render
		return array
		(
			'order'			=>	$order,
			'dir'			=>	$dir,
			'page'			=>	$page,
			
			'ordering'		=>	$ordering,
			'pages'			=>	$pages,
			
			'from'			=>	$from,
			'to'			=>	$to,
			'total'			=>	$total,
			
			'friends'		=>	$users
		);
	}
	
	public function friend($id)
	{
		if($this->user->authenticated())
		{
			$friended = \model\Friend::get('WHERE user_id=? AND target_id=?', array($this->user->id, $id))->fetch();
			
			if($friended)
			{
				$friended->delete();
			} else
			{
				$friend = new \model\Friend(array
				(
					'user_id'	=>	$this->user->id,
					'target_id'	=>	$id
				), true);
				
				$friend->create();
			}
			
			return $this->json(true);
		}
	}
	
	# Settings
	public function settings()
	{
		if(!$this->user->authenticated())
		{
			$this->redirect('Games', 'browse');
		}
		
		$form = $this->user->edit('settings_form');
		
		return $this->render('users/settings.html', array
		(
			'form'	=>	$form
		));
	}
	
	# Messages
	public function messages($tab='inbox', $target='')
	{
		if(!$this->user->authenticated())
		{
			$this->redirect('Games', 'browse');
		}
		
		// Vars
		$form = null;
		$messages = array();
		
		// New message
		if($tab == 'new_message')
		{
			$message = new \model\Message(array
			(
				'target_id'	=>	$target
			));
			
			$form = $message->create('send_message');
			
			if($form->valid)
			{
				$this->redirect('Users', 'messages', array('tab'=>'outbox'));
			}
		}
		
		// Messages
		if($tab == 'inbox')
		{
			// Inbox
			$messages = \model\Message::get('WHERE `type`="inbox" AND `target_id`=? ORDER BY `id` DESC LIMIT 100', $this->user->id)->fetchAll();
			
			$this->user->unread = 0;
		} else
		{
			// Outbox
			$messages = \model\Message::get('WHERE `type`="outbox" AND `target_id`=? ORDER BY `id` DESC LIMIT 100', $this->user->id)->fetchAll();
		}
		
		// Render
		return $this->render('users/messages.html', array
		(
			'tab'		=>	$tab,
			'form'		=>	$form,
			'messages'	=>	$messages
		));
	}
}